// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
|==========||==========|
GS Shader 2.1

By Goldshadow12
|==========||==========|
*/

#include "fragmentVersionCentroidUV.h"
#include "uniformEntityConstants.h"

#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "util.h"

#include "lib/terrain.h"
#include "lib/water.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;

#ifdef USE_MULTITEXTURE
	LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;
#endif

in vec4 light;
in vec4 fogColor;

in highp vec3 position;

in float addfog;

#ifdef COLOR_BASED
	in vec4 vertColor;
#endif

#ifdef USE_OVERLAY
	in highp vec4 overlayColor;
#endif

#ifdef TINTED_ALPHA_TEST
	in float alphaTestMultiplier;
#endif

#ifdef GLINT
	in vec2 layer1UV;
	in vec2 layer2UV;
	in vec4 tileLightColor;
	in vec4 glintColor;
#endif

vec4 glintBlend(vec4 dest, vec4 source) {
	return vec4(source.rgb * source.rgb, source.a) + vec4(dest.rgb, 0.0);
}

#ifdef USE_EMISSIVE
#ifdef USE_ONLY_EMISSIVE
#define NEEDS_DISCARD(C) (C.a == 0.0 || C.a == 1.0 )
#else
#define NEEDS_DISCARD(C)	(C.a + C.r + C.g + C.b == 0.0)
#endif
#else
#ifndef USE_COLOR_MASK
#define NEEDS_DISCARD(C)	(C.a < 0.5)
#else
#define NEEDS_DISCARD(C)	(C.a == 0.0)
#endif
#endif

void entityRender( inout vec4 clr ){

    vec3 n = normalize(cross(dFdx(position.gbr),dFdy(position.gbr)));

    float night = max(1.-min(pow(light.r*1.8,5.),1.),.0),rain = clamp((1.-pow(FOG_CONTROL.y,11.)),.0,1.);

    vec3 fn = mix(mix(vec3(.9,.95,1.),vec3(.2,.5,.7)*.8,night),vec3(.6),rain);

    float shadowmap = mix(.0,.4,smoothstep(.93,.91,TILE_LIGHT_COLOR.r));

    shadowmap = mix(shadowmap,.4,max(max(-n.r, abs(n.b)),.0));
    
    clr.rgb = Contrast(tone(clr.rgb*fn),.8);
    clr.rgb = mix(clr.rgb, vec3(.0), shadowmap*(1.-night)*(1.-rain));
    clr.rgb = HDR(clr.rgb);
    
    highp float wv = Waves(position*.05);
    
    if(FOG_CONTROL.x == .0)clr.rgb = mix(clr.rgb, clr.rgb * vec3(3.), mix(1.,.0,wv)*FOG_COLOR.b);

}

void main()
{
	vec4 color = vec4(1.0)*1.3;
	
	vec3 shd = vec3(.81,.83,.85);
	
	vec3 day_ = vec3(0.9,0.95,1.0);
	vec3 night_ = vec3(0.6,0.7,1.0)*0.4;

#ifndef NO_TEXTURE
#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE)
	color = texture2D( TEXTURE_0, uv );
#else
	color = texture2D_AA(TEXTURE_0, uv);
#endif

#ifdef MASKED_MULTITEXTURE
	vec4 tex1 = texture2D( TEXTURE_1, uv );

	float maskedTexture = ceil( dot( tex1.rgb, vec3(1.0, 1.0, 1.0) ) * ( 1.0 - tex1.a ) );
	color = mix(tex1, color, clamp(maskedTexture, 0.0, 1.0));
#endif

#if defined(ALPHA_TEST) && !defined(USE_MULTITEXTURE) && !defined(MULTIPLICATIVE_TINT)
	if(NEEDS_DISCARD(color))
		discard;
#endif

#ifdef TINTED_ALPHA_TEST
    vec4 testColor = color;
    testColor.a *= alphaTestMultiplier;
	if(NEEDS_DISCARD(testColor))
		discard;
#endif
#endif

#ifdef COLOR_BASED
	color *= vertColor;
#endif

#ifdef MULTI_COLOR_TINT
	vec2 colorMask = color.rg;

	color.rgb = colorMask.rrr * CHANGE_COLOR.rgb;

	color.rgb = mix(color, colorMask.gggg * MULTIPLICATIVE_TINT_CHANGE_COLOR, ceil(colorMask.g)).rgb;
#else

#ifdef USE_COLOR_MASK
	color.rgb = mix(color.rgb, color.rgb*CHANGE_COLOR.rgb, color.a);
	color.a *= CHANGE_COLOR.a;
#endif

#ifdef ITEM_IN_HAND
	color.rgb = mix(color.rgb, color.rgb*CHANGE_COLOR.rgb, vertColor.a);
#if defined(MCPE_PLATFORM_NX) && defined(NO_TEXTURE) && defined(GLINT)
	vec3 dummyColor = texture2D(TEXTURE_0, vec2(0.0, 0.0)).rgb;
	color.rgb += dummyColor * 0.000000001;
#endif
#endif

#endif

#ifdef USE_MULTITEXTURE
	vec4 tex1 = texture2D( TEXTURE_1, uv );
	vec4 tex2 = texture2D( TEXTURE_2, uv );
	color.rgb = mix(color.rgb, tex1.rgb, tex1.a);
#ifdef ALPHA_TEST
	if (color.a < 0.5 && tex1.a == 0.0) {
		discard;
	}
#endif

#ifdef COLOR_SECOND_TEXTURE
	if (tex2.a > 0.0) {
		color.rgb = tex2.rgb + (tex2.rgb * CHANGE_COLOR.rgb - tex2.rgb)*tex2.a;//lerp(tex2.rgb, tex2 * changeColor.rgb, tex2.a)
	}
#else
	color.rgb = mix(color.rgb, tex2.rgb, tex2.a);
#endif
#endif

#ifdef MULTIPLICATIVE_TINT
	vec4 tintTex = texture2D(TEXTURE_1, uv);
#ifdef MULTIPLICATIVE_TINT_COLOR
	tintTex.rgb = tintTex.rgb * MULTIPLICATIVE_TINT_CHANGE_COLOR.rgb;
#endif

#ifdef ALPHA_TEST
	color.rgb = mix(color.rgb, tintTex.rgb, tintTex.a);
	if (color.a + tintTex.a <= 0.0) {
		discard;
	}
#endif
	
#endif

#ifdef USE_OVERLAY
	color.rgb = mix(color, overlayColor, overlayColor.a).rgb;
#endif

#ifdef USE_EMISSIVE
	color *= mix(vec4(1.0), light, color.a );
#else
	color *= light;
#endif

entityRender(color);

color.rgb = mix( color.rgb, fogColor.rgb, fogColor.a );

#ifdef GLINT

	vec4 layer1 = texture2D(TEXTURE_1, fract(layer1UV)).rgbr * glintColor;
	vec4 layer2 = texture2D(TEXTURE_1, fract(layer2UV)).rgbr * glintColor;
	vec4 glint = (layer1 + layer2) * tileLightColor;

	color = glintBlend(color, glint);
#endif

#ifdef UI_ENTITY
	color.a *= HUD_OPACITY;
#endif
	gl_FragColor = color;
}
